<?php

namespace App\Http\Middleware;

use Closure;
use Response;
use Route;
use Session;

class SitePageVisitorCheckerMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $site_id = Session::get('SITE_ID');
        $alias = Session::get('ALIAS1');
        $acc_gr_id = Session::get('ACADEMIC_GROUP_ID');

       // dd($user_type);
        if ($site_id && $acc_gr_id && $alias !='eduworld'){
            return $next($request);

        } else{
            $currentRoute = Route::getRoutes()->match($request)->getName();
            Session::put('redirect_route',$currentRoute);

            if ($request->ajax() || $request->isJson()) {
                return Response::json(['message' => 'Site Or Alias Or Academic Group Missing!'.($site_id.' '.$alias.' '.$acc_gr_id)], 401);
            } else {
                return redirect()->route('edu-site-impersonate-form');
            }




           /* return Response::make(view('default.admin.edu.site.site-impersonate-form', [
                'message' => 'you are visiting site page but you dont have site id yet!',
                'title' => 'Site Id Not Found',
                'viewType' => 'Site Id Route Not Found'
            ]), 401);*/
        }
    }
}
